<?php
    /**
    *
    * copyright (c) 2013-2023 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    *
    * File che consente di gestire le operazioni con le immagini
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreUpload.php";
    include "../gUtil/ControlloreStringhe.php";
    include "../classi/Immagine.php";
    
    session_start();
    controlloAccessoAdmin();
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb   = new DbManager($costantiDatabase);
    $operazione = filter_input(INPUT_POST,"operazione",FILTER_SANITIZE_STRING);
    
    switch ($operazione) {
        case 'caricaAudio':
            $tipiFileAmmessi = array("audio/mpeg","application/ogg");
            $percorsoBase = "file/audio/";
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, "");
            $gestoreUpload->salvaFile();
            echo "ok";
            break;
        case 'caricaVideo':
            $tipiFileAmmessi = array("video/mp4","video/ogg","video/webm");
            $gestoreUpload = new GestoreUpload("file", $tipiFileAmmessi, 8, "../$percorsoBase", 0, "");
            $esitoUpload  = $gestoreUpload->salvaFile();
            $gestoreUpload->salvaFile();
            echo "ok";
            break;
        case 'eliminaFile': // questa azione viene usata quando si eliminano immagini dall'area risorse
            $percorso = filter_input(INPUT_POST,"percorso",FILTER_SANITIZE_STRING);
            unlink($percorso);
            echo "ok";
            break;
    }